/**
 * Define the tabs and videos contained within for the Tutorials page.
 */
BoldGridTutorials = {

	title : "Welcome to BoldGrid!",

	tabs : [
			{

				tab : 'Inspirations',

				links : [
						{
							content_heading : 'Inspirations - Getting Started',
							link : 'Introduction to BoldGrid',
							time : '8:41',
							icon : 'dashicons-nametag',
							video_id : 'qAz3UEJquSk',
							video_title : 'Introduction to BoldGrid',
							video_summary : "In this video, we cover a basic overview of BoldGrid. You'll see in a short time how easy BoldGrid is to build, customize, and launch your first website.<br /><br />" +
								"BoldGrid is powerful not only because of how easy it is to use, but also because it's built on WordPress. This allows your website to grow with your business and move with you. From customizing the look and feel of your website in the customizer, to adding your own content, you'll have the website you've always wanted and your business deserves in no time.",
						},
						{
							link : 'Understanding Active vs. Staging Sites',
							time : '1:19',
							icon : 'dashicons-admin-multisite',
							video_id : 'n3lWV-pfwo0',
							video_title : 'Understanding Active vs. Staging Sites',
							video_summary : 'Learn the difference between Active and Staging sites in this BoldGrid video.',
						},
						{
							link : 'Installing your First Inspiration',
							time : '1:57',
							icon : 'dashicons-lightbulb',
							video_id : 'yrn2zPq0cOw',
							video_title : 'Installing your First Inspiration',
							video_summary : 'Learn how to install a BoldGrid Inspiration. An Inspiration in BoldGrid is a starting point for you to build your custom website on. It is much like a customizable framework, enabling you to make your site unique.',
						},
						{
							link : 'Introduction to Copyright Coins ',
							time : '1:55',
							icon : 'dashicons-image-filter',
							video_id : 'iZH6U7UlYfg',
							video_title : 'Introduction to Copyright Coins ',
							video_summary : 'Copyright Coins can be used to purchase stock images from providers within BoldGrid itself. In this video, we show you how they work and how to make purchases.',
						},
						{
							link : 'Changing the Look & Feel of The Dashboard',
							time : '1:29',
							icon : 'dashicons-welcome-widgets-menus',
							video_id : 't4X6j4RosZQ',
							video_title : 'Changing the Look and Feel of The Dashboard',
							video_summary : 'BoldGrid changes the default layout of the dashboard menu. If you wish to keep the traditional style, follow the instructions in this video.',
						},
						{
							link : 'How to Add Pages',
							time : '1:33',
							icon : 'dashicons-welcome-add-page',
							video_id : 'z7aM9piMZg0',
							video_title : 'How to Add Pages',
							video_summary : 'Adding new pages is important in growing your website. In this video, we demonstrate how to add new content pages to your BoldGrid website. ',
						},
						{
							link : 'How to Add a GridBlock',
							time : '1:37',
							icon : 'dashicons-welcome-add-page',
							video_id : 'v7as06nmeFs',
							video_title : 'How to Add a GridBlock',
							video_summary : 'GridBlocks are the building blocks of BoldGrid site pages. Learn how to add them to your pages in this tutorial.',
						},
						{
							link : 'Viewing your Site on Different Devices',
							time : '1:39',
							icon : 'dashicons-welcome-widgets-menus',
							video_id : 'yafSP5a6FP4',
							video_title : 'Viewing your Site on Different Devices',
							video_summary : 'Curious to see what your pages look like on a tablet or phone? Learn how to view the pages on different devices so you can plan the perfect BoldGrid site.',
						},
						{
							link : 'How to Change your Theme in BoldGrid',
							time : '2:15',
							icon : 'dashicons-admin-page',
							video_id : 'c4LMiq4vFWU',
							video_title : 'How to Change your Theme in BoldGrid',
							video_summary : 'After you have installed your chosen Inspiration, you may want to change the overall look and feel by switching themes. This tutorial guide shows you how to switch site themes in BoldGrid.',
						},
						{
							link : 'How to Start Over in BoldGrid',
							time : '1:38',
							icon : 'dashicons-admin-home',
							video_id : 'GVP40D5P7sQ',
							video_title : 'How to Start Over in BoldGrid',
							video_summary : "There are times when you simply want to start fresh. Perhaps you have been newly inspired or just need a reset. This video guide demonstrates how to start over from scratch in BoldGrid.",
						}, ],

			},
			{

				tab : 'Customizations for the New User',

				links : [
						{
							content_heading : 'Get it Done (1-2 hrs)',
							link : 'Evaluating your Inspiration',
							time : '1:27',
							icon : 'dashicons-visibility',
							video_id : 'YNBVtfjF3Hc',
							video_title : 'Evaluating your Inspiration',
							video_summary : 'Once you have installed your Inspiration, you will want to take a tour of your site to note any changes you may need to make to your site. This video walks you through that process so you can further customize your BoldGrid site.',
						},
						{
							link : 'How to Remove Unwanted Pages',
							time : '1:18',
							icon : 'dashicons-trash',
							video_id : 'h--wXFfKYfI',
							video_title : 'How to remove Unwanted Pages',
							video_summary : 'Have pages you no longer need on your site? In this video tutorial, you will learn how to remove pages from within the BoldGrid dashboard.',
						},
						{
							link : 'Changing your Site Title & Logo',
							time : '1:59',
							icon : 'dashicons-info',
							video_id : 'W5aUlQCAepY',
							video_title : 'Changing your Site Title & Logo',
							video_summary : "In this video tutorial, we'll show you how to change your site title in the BoldGrid dashboard. This way you can brand the site for your business.",
						},
						{
							link : 'How to Change your Site Colors',
							time : '2:27',
							icon : 'dashicons-admin-appearance',
							video_id : 'LKuzJx_cEjU',
							video_title : 'How to Change your Site Colors',
							video_summary : 'Do you love the layout but want to change the colors to better fit your brand? Learn how to change the website colors in BoldGrid.',
						},
						{
							link : 'How to Change your Background',
							time : '2:42',
							icon : 'dashicons-format-image',
							video_id : 'icw0FGTeM6k',
							video_title : 'How to Change your Background',
							video_summary : 'In this video tutorial, we demonstrate how you can replace the stock background image with one of your own choosing.',
						},
						{
							link : 'How to Edit your Menus',
							time : '2:34',
							icon : 'dashicons-menu',
							video_id : 'J3YHfte_Z4s',
							video_title : 'How to Edit your Menus',
							video_summary : 'Menus are important for your visitors to navigate your site properly. In this video tutorial, we show you how to manage your menus in BoldGrid for both site navigation and social media.',
						},
						{
							link : 'How to Edit your (Header / Footer)  Widgets',
							time : '2:35',
							icon : 'dashicons-welcome-widgets-menus',
							video_id : 'r659kt7FdiI',
							video_title : 'How to Edit your (Header / Footer)  Widgets',
							video_summary : 'Widgets are small pieces of code that perform a single function. Learn how to add and edit them in BoldGrid to better customize your site.',
						},
						{
							link : 'How to Work in the Advanced Tab in Customizer',
							time : '2:16',
							icon : 'dashicons-admin-settings',
							video_id : '66eQAZsoxgU',
							video_title : 'How to work in the Advanced Tab in Customizer',
							video_summary : 'The advanced tab has features that do not fit in the other BoldGrid customizer tabs. This video goes over the tab and the features it contains.',
						},
						{
							link : 'How to Configure Your Contact Form',
							time : '1:55',
							icon : 'dashicons-format-aside',
							video_id : 'vJMkMLJBGk8',
							video_title : 'Configuring Your Contact Form for Submission Notification in BoldGrid ',
							video_summary : 'Learn to configure your Ninja Form to send you a notification email when someone submits a form.',
						},
						{
							link : 'How to Edit Pages',
							time : '1:51',
							icon : 'dashicons-admin-page',
							video_id : 'GWwXzIUXg8c',
							video_title : 'How to Edit Pages',
							video_summary : 'Your content will need to be changed or refreshed from time to time. Learn how to edit pages using the BoldGrid editor.',
						},
						{
							link : 'How to Search for Images in BoldGrid',
							time : '2:05',
							icon : 'dashicons-camera',
							video_id : 'UkHNezbw1Zo',
							video_title : 'How to Search for Images in BoldGrid',
							video_summary : 'BoldGrid Connect Search connects you to exciting stock images for your website. Learn how to find the best images for your site.',
						},
						{
							link : 'How to Add & Replace Images',
							time : '1:57',
							icon : 'dashicons-format-gallery',
							video_id : 'r1JgIWglkMA',
							video_title : 'How to Add & Replace Images',
							video_summary : 'Images are a very important element for your site. Learn how to add or replace them within BoldGrid so your site can truly stand out.',
						}, ],
			},
			{
				tab : 'Advanced For WordPress Users',

				links : [
						{
							content_heading : 'Advanced For WordPress Users',
							link : 'Advanced for WP Users',
							time : '5:51',
							icon : 'dashicons-wordpress',
							video_id : 'fAbVXapGx48',
							video_title : 'Advanced For WordPress Users',
							video_summary : "In this video, we'll walk the advanced users through the basic functionality of BoldGrid and how it differs from standard WordPress. This introduction is designed for those users who have previous experience working with WordPress from a designer or developer standpoint.",
						}, ]
			} ],

};

var BoldGridDashboard = BoldGridDashboard || {};

(function($, _, Backbone) {

	"use strict";

	// This is the primary view for the customer journey information.
	var BoldGridDashboardJourneys = Backbone.View
			.extend({

				initialize : function() {

					this.render();

				},

				boldgridAccordion : function() {

					/**
					 * Make an accordion for the text at the top of the widget,
					 * the "Customer Journeys," which are rendered from the
					 * collection, BoldGridCustomerJourney.
					 *
					 * @see : collection : BoldGridCustomerJourney
					 *
					 * @since 1.13
					 */
					jQuery( '.boldgrid-accordion-content:first' ).show();
					jQuery( '.boldgrid-arrow:first').toggleClass( 'boldgrid-arrow-toggle' );
					jQuery( '#boldgrid-accordion' ).find('.boldgrid-accordion-toggle').click(function() {
						// StateMachine open the closed, close the opened etc
						jQuery( this ).next().slideToggle( 600 );
						jQuery( 'span', this ).toggleClass( 'boldgrid-arrow-toggle' );
						jQuery( '.boldgrid-accordion-content').not( jQuery( this ).next() )
							.slideUp( 'fast' );
						jQuery( '.boldgrid-arrow-toggle' ).not( jQuery( 'span', this ) )
							.removeClass( 'boldgrid-arrow-toggle' );
					});
				},

				render : function() {
					var html = '';

					this.collection.each( function( journey ) {
						html += '<h3 class="boldgrid-accordion-toggle"><span class="boldgrid-arrow"></span>' + journey.get('path') + '</h3>';
						html += '<div class="boldgrid-accordion-content">' + journey.get('text') + '</div>';
					});

					this.$el.html( html );
					this.boldgridAccordion();
				}
			});

	// This is the collection of the BoldGrid Customer Journeys data
	var BoldGridCustomerJourney = new Backbone.Collection(
			[

					{

						path : "First time building a website with BoldGrid or first time building a site at all?",
						text : "<p>It is best to start with the videos under the “Inspiration” tab below. It will show you the process for choosing the look and feel of your Base Website (including your WordPress theme) and picking pages typical for your industry (called Page Sets). You can also just start by going to “Inspirations” in the menu at left.</p><p>After you complete the Inspiration phase, you will then customize your site. We created guides based on what we recommend you do based on time available. The three Customization tabs below will guide you through the process.</p>"

					},
					{

						path : "Finished your first “Inspiration” install but want to try a different theme or get more pages?",
						text : "<p>Just use \"Inspirations\" in the menu at left again. You can also learn more about it under the Inspiration tab below.</p>"

					},
					{

						path : "Familiar with creating sites in WordPress but not running an Active site on this install?",
						text : "<p>We have made a few significant changes you may want to review before starting with the Inspiration Tab. Check out the Advanced for WordPress Users tab below. </p>"

					},
					{

						path : "Running this on a WordPress install with an Active website?",
						text : "<p>It is highly advised to review the Advanced for WordPress Users tab below before you start the Inspiration Phase.</p>"

					} ]

	);

	// Each BoldGrid customer journey is the text displayed above the tabs
	var boldgridDashboardJourneys = new BoldGridDashboardJourneys({

		el : '#boldgrid-accordion',

		collection : BoldGridCustomerJourney

	});

	// This is the primary view for the BoldGrid Dashboard
	var BoldGridDashView = Backbone.View.extend({
		/**
		 * Main view for BoldGrid Dashboard Widget This is the set of
		 * tabs and actual content displayed in the dashboard widget.
		 */
		// Handlebars template
		template : Handlebars.compile( jQuery( "#boldgrid-dashboard-view" ).html() ),
		// establish click even handlers for tabs and tab content
		events : {
			// on click for tab content links
			'click #boldgrid-tab-view-navigation li.boldgrid-tab-links' : 'boldgridVideoSelector',
			// on click for actual tabs
			'click li.tab-menu-item' : 'boldgridTabReset',
			// on click for playing YouTube videos.
			'click div.play-button' : 'boldgridVideoPlay'
		},

		// tab content video swapping
		boldgridVideoSelector : function(e) {
			/**
			 * Click event handler for displaying the relevant videos
			 * when users click on tab navigation links in the BoldGrid
			 * dashboard widget.
			 *
			 * @since 1.14
			 */
			// get the current target's' data-link-key
			var video = jQuery(e.currentTarget).data('link-key');
			// show matching content for element's data-link-key
			jQuery( ".boldgrid-tab-content-wrapper[data-link-key='" + video + "']")
				// make it look pretty
				.fadeIn("slow")
				.show();
			// hide all other elements that don't match data-link-key
			jQuery( ".boldgrid-tab-content-wrapper:not([data-link-key='" + video + "'])")
				.hide();

			/**
			 * Kill YouTube Video Players that are playing on tabs if
			 * users navigate away from current tab view. Then replace
			 * them with the corresponding thumbnails.
			 *
			 * @since 1.15
			 */
			// define the BoldGrid video player location
			var bgplayer = document.getElementById('youtube-iframe');
			// only destroy if exists
			if (typeof (bgplayer) != 'undefined' && bgplayer !== null) {
				// grab it's parent
				var parent = bgplayer.parentNode;
				// generate the image tag
				var image = document.createElement('img');
				// add css properties
				image.className = "youtube-thumb";
				// get the thumbnail source from YouTube
				image.setAttribute("src", "//i.ytimg.com/vi/" + bgplayer.parentNode.dataset.id + "/sddefault.jpg");
				// add thumb to dom
				parent.appendChild( image );
				// destroy YouTube video player
				parent.removeChild( bgplayer );
				// generate new play button
				var playbutton = document.createElement( 'div' );
				playbutton.className = 'play-button';
				parent.appendChild( playbutton );
			}
		},

		boldgridVideoPlay : function( e ) {
			/**
			 * Play YouTube video if users click on play buttons on the
			 * YouTube thumbnails
			 *
			 * @since 1.15
			 */
			// define the player, ie iframe.
			var iframe = document.createElement( "iframe" );
			// set src of iframe
			iframe.setAttribute( "src",
				"//www.youtube.com/embed/" + e.currentTarget.parentNode.dataset.id +
				"?autoplay=1&autohide=2&border=0&wmode=opaque&enablejsapi=1&theme=light&controls=1&rel=0&showinfo=0");
			iframe.setAttribute( "frameborder", "0" );
			iframe.setAttribute( "id", "youtube-iframe" );
			iframe.setAttribute( "allowfullscreen", "" );
			// do the deed
			e.currentTarget.parentNode.replaceChild( iframe, e.currentTarget );
		},

		// reset tab view for navigation
		boldgridTabReset : function() {
			/**
			 * Kill YouTube Video Players that are playing on tabs if
			 * users navigate away from current tab view. Then replace
			 * them with the corresponding thumbnails.
			 *
			 * @since 1.15
			 */
			// define the BoldGrid video player location
			var bgplayer = document.getElementById('youtube-iframe');
			// only destroy if exists
			if ( typeof ( bgplayer ) != 'undefined' && bgplayer !== null ) {
				// grab it's parent
				var parent = bgplayer.parentNode;
				// generate the image tag
				var image = document.createElement( 'img' );
				// add css properties
				image.className = 'youtube-thumb';
				// get the thumbnail source from YouTube
				image.setAttribute( "src", "//i.ytimg.com/vi/" + bgplayer.parentNode.dataset.id + "/sddefault.jpg" );
				// add thumb to dom
				parent.appendChild( image );
				// destroy YouTube video player
				parent.removeChild( bgplayer );
				// generate new play button
				var playbutton = document.createElement( 'div' );
				playbutton.className = 'play-button';
				parent.appendChild( playbutton );
			}

			/**
			 * Reset the tab content back to 0 for default display when
			 * users switch between tabs.
			 *
			 * @since 1.14
			 */

			// hide all the tab content currently in view
			jQuery( '.boldgrid-tab-content-wrapper' ).hide();

			// show the default content, data-link-key 0
			jQuery( ".boldgrid-tab-content-wrapper[data-link-key='0']" )
				.fadeIn( 'slow' )
				.show();

		},

		// Custom YouTube Player
		boldgridYouTubePlayer : function() {

			jQuery( document ).ready( function() {
				/**
				 * Prevent YouTube embeds rendered in
				 * view from draining resources. Also
				 * adds overlay image in orange for
				 * player button, and sets up the video
				 * embed to be done on a click event
				 * opposed to straight embedding it by
				 * grabbing thumbnails from youtube
				 * until video is selected by user.
				 *
				 * @since 1.13
				 */

				( function() {
					var v = document.getElementsByClassName( 'youtube-player' );
					for ( var n = 0; n < v.length; n++ ) {
						var p = document.createElement( 'div' );
						p.innerHTML = boldgridThumb( v[n].dataset.id );
						p.onclick = boldgridIframe;
						v[n].appendChild( p );
					}
				})();

				function boldgridThumb( id ) {
					return '<img class="youtube-thumb" src="//i.ytimg.com/vi/' + id + '/sddefault.jpg"><div class="play-button"></div>';
				}

				function boldgridIframe() {
					var iframe = document.createElement( 'iframe' );

					iframe.setAttribute( "src",
						"//www.youtube.com/embed/" +
						this.parentNode.dataset.id +
						"?autoplay=1&autohide=2&border=0&wmode=opaque&enablejsapi=1&theme=light&controls=1&rel=0&showinfo=0");
					iframe.setAttribute( "frameborder", "0" );
					iframe.setAttribute( "id", "youtube-iframe" );
					/**
					 * @bugfix fullscreen won't show in
					 *         chrome despite setting
					 *         fs=1 - added attribute
					 *         for allowfullscreen to
					 *         iframe to circumvent.
					 *         Cannot set fs=anything *
					 */
					iframe.setAttribute( "allowfullscreen", "" );
					this.parentNode.replaceChild( iframe, this );
				}
			});
		},

		// Tab data to populate our template with - contains $el
		boldgridTabData : function() {
			this.$el.html( this.template( BoldGridTutorials ) );
		},

		// This generates the main tab view.
		boldgridTabs : function() {
			/**
			 * This generates the tabs from the BoldGrid tab data html
			 * that is rendered.
			 *
			 * @since 1.13
			 */
			( function() {
				var Tabs;
				Tabs = ( function() {
					// template for tabs to be rendered
					var templates = {
						tplTabNav : Handlebars.compile( "<ul class='inline-list tabs-navigation show-desktop' role='tablist'>{{#each tab}}<li role='presentation' class='tab-menu-item'><a href='#{{tabId}}' id='TabController-{{tabId}}' class='txt-btn tabs-navigation__button nav-tab' role='tab' aria-selected='false' aria-controls='{{tabId}}' tabindex=-1 aria-expanded='false'>{{{tabTitle}}}</a></li>{{/each}}</ul>" )
					};

					/**
					 * Sets up the Tabs
					 *
					 * @param $container -
					 *            parent of the items that will be
					 *            tabbed together
					 * @param $options -
					 *            any overrides to the classes set below
					 */

					function Tabs( $container, options ) {

						var defaults = {
							// the default tab to start on (index)
							default_tab : "0",
							// wrapper the entire panel and content in a
							// tab view
							tab_class_panel : ".tabs-container__panel",
							// title for each tab/accordion made
							tab_class_title : ".tabs-container__title",
							// prefix for tab navigation on
							// tab/accordion
							tab_nav_id : "TabNav"
						};

						this.$container = $container.addClass( 'tabs-init' );
						this.options = jQuery.extend( {}, defaults, options );
						this.currentTab = null;
						this.init();
					}

					/**
					 * Creates a data object for all tabs within the
					 * widget Saves each tab ID and title, to be used to
					 * create desktop tab nav if needed adds ARIA roles
					 * as it grabs tab data
					 */
					Tabs.prototype.fetchTabData = function() {
						// stores data for all tabs in the widget
						this.tabData = [];
						var i = 0,
						$tab_panels = this.$tab_panels,
						len = $tab_panels.length,
						$currentPanel,
						$panelTitle,
						currentPanelData;

						// save each tab from the html
						for (i; i < len; i++) {
							$currentPanel = jQuery( $tab_panels[i] );
							$panelTitle = $currentPanel.prev( this.options.tab_class_title );

							currentPanelData = {
								tabId : $tab_panels[i].id,
								tabTitle : $panelTitle.text()
							};

							this.tabData.push( currentPanelData );
							// update ARIA attrs for the panel and
							// accordion title
							$currentPanel.attr({
								"role" : "tabpanel",
								"aria-hidden" : "true"
							});

							$panelTitle
								.attr({
									"tabindex" : "-1",
									"role" : "tab",
									"aria-controls" : currentPanelData.tabId,
									"aria-selected" : "false",
									"aria-expanded" : "false"
								}).removeClass( 'nav-tab-active' );
						}
					};

					/**
					 * Creates the HTML for the tab views
					 */

					Tabs.prototype.createTabNav = function() {
						this.tabNav = true;
						this.$tabNav = jQuery( templates.tplTabNav({
							"tab" : this.tabData
						}) ).prependTo( this.$container );
						this.$tabNavItems = this.$tabNav.find( 'a' );
						// Add class to indicate that there's a navigation.
						this.$container.addClass( 'tabs-nav-init' );
					};

					/**
					 * Binds the tab nav events
					 */

					Tabs.prototype.bindNavEvents = function() {
						var app = this;
						this.$tabNav.on( "click", "a", function( e ) {
							e.preventDefault();
							var $target = jQuery( e.currentTarget ),
							$tabPanel = jQuery( this.getAttribute( 'href' ) );

							if ( ! app.isCurrentTab($tabPanel ) ) {
								app.closeTab();
								app.openTab( $tabPanel );
							}
						});

						this.$tabNav.on( "keydown", "a", function( e ) {

							var currentIndex = app.handleKeyPress(e);

							if ( currentIndex !== null ) {
								app.closeTab();
								var panelId = app.tabData[currentIndex].tabId;
								app.openTab( jQuery( document.getElementById( panelId ) ) );
								// @fix - focus only here so doesn't steal focus on pageload
								app.currentTab.$navItem.focus();
							}
						});
					};

					/**
					 * identify if the clicked tab is what's currently
					 * open
					 *
					 * @param $tab_panel -
					 *            jQuery collection of the tab to be
					 *            evaluated
					 */
					Tabs.prototype.isCurrentTab = function( $tab_panel ) {
						return this.currentTab.$tab_panel.get( 0 ) == $tab_panel.get( 0 );
					};

					/**
					 * Key handler for tabs
					 *
					 * @param e -
					 *            event
					 */

					Tabs.prototype.handleKeyPress = function( e ) {
						var keyCodes, currentIndex = this.currentTab.position;

						keyCodes = {
							DOWN : 40,
							ENTER : 13,
							ESCAPE : 27,
							HOME : 36,
							LEFT : 37,
							PAGE_DOWN : 34,
							PAGE_UP : 33,
							RIGHT : 39,
							SPACE : 32,
							TAB : 9,
							UP : 38
						};

						switch ( e.keyCode ) {

						case keyCodes.LEFT:
						case keyCodes.UP:
							currentIndex--;
							if ( currentIndex < 0 ) {
								currentIndex = this.tabData.length - 1;
							}
							break;
						case keyCodes.END:
							currentIndex = this.tabData.length - 1;
							break;
						case keyCodes.HOME:
							currentIndex = 0;
							break;
						case keyCodes.SPACE:
						case keyCodes.ENTER:
							currentIndex = this.handleEnter( currentIndex );
							break;
						case keyCodes.RIGHT:
						case keyCodes.DOWN:
							currentIndex++;
							if ( currentIndex >= this.tabData.length ) {
								currentIndex = 0;
							}
							break;
						default:
							currentIndex = null;
						}

						return currentIndex;
					};

					Tabs.prototype.handleEnter = function( currentIndex ) {
						// enter will select new panel or do nothing if
						// focus is on the active panel
						// so we have to deal with the currently focused
						// element rather than the selected tab
						var currentTabByFocusIndex = document.getElementById( document.activeElement.getAttribute( "aria-controls" ) );

						if ( currentTabByFocusIndex !== this.currentTab.$tab_panel.get( 0 ) ) {
							currentIndex = this.$tab_panels.index( currentTabByFocusIndex );
						}

						return currentIndex;
					};

					/**
					 * Opens the tab
					 *
					 * @param $tab_panel jQuery collection of opened tab
					 */

					Tabs.prototype.openTab = function( $tab_panel ) {
						var options = this.options;
						this.currentTab = {
							$tab_panel : $tab_panel.attr({
								"aria-hidden" : "false",
								"tabindex" : "0"
							}),
							$title : $tab_panel.prev( options.tab_class_title ).attr({
								"aria-selected" : true,
								"aria-expanded" : true,
								"tabindex" : "0"
							}).addClass( "nav-tab-active" ),
							position : this.$tab_panels.index( $tab_panel )
						};

						if ( this.tabNav ) {
							this.updateTabNav();
						}
					};

					/**
					 * closes a tab if there's one open and a new one
					 * has been activated Only have one section open at
					 * a time
					 */

					Tabs.prototype.closeTab = function() {
						var currentTab = this.currentTab;

						currentTab.$tab_panel.attr({
							"aria-hidden" : "true"
						}).removeAttr( "tabindex" );

						// update accordion title values as well so
						// everything is in synch
						currentTab.$title.attr({
							"tabindex" : "-1",
							"aria-selected" : "false",
							"aria-expanded" : "false"
						}).removeClass( "nav-tab-active" );

						if ( this.tabNav ) {
							currentTab.$navItem.attr({
								"tabindex" : "-1",
								"aria-selected" : "false",
								"aria-expanded" : "false"
							}).removeClass("nav-tab-active");
						}

						this.currentTab = null;
					};

					/**
					 * Updates the tab nav once a new tab has been
					 * opened
					 *
					 * @param $tab -
					 *            jQuery element for the tab that was
					 *            just opened
					 */

					Tabs.prototype.updateTabNav = function() {
						var currentTab = this.currentTab;

						currentTab.$navItem = this.$tabNavItems.eq( currentTab.position );

						currentTab.$navItem.attr({
							"tabindex" : "0",
							"aria-selected" : "true",
							"aria-expanded" : "true"
						}).addClass( "nav-tab-active" );

					};

					/**
					 * Binds the Accordion events which is for tablet
					 * and mobile only
					 */

					Tabs.prototype.bindAccordionEvents = function() {
						var app = this;
						// @Bugfix: https://bugs.webkit.org/show_bug.cgi?id=133613
						this.$accordion.on( "keydown",
							this.options.tab_class_title, function( e ) {
								var currentIndex = app.handleKeyPress( e );

								if ( currentIndex !== null ) {
									app.handleAccordion( app.$tab_panels.eq( currentIndex ) );
								}
							}).find( ".tabs-container__title" ).on( "click", function( e ) {
								e.preventDefault();
								app.handleAccordion( jQuery( e.currentTarget ).next( app.options.tab_class_panel ) );
							});
					};

					Tabs.prototype.handleAccordion = function( $tab_panel ) {
						if ( ! this.isCurrentTab( $tab_panel ) ) {
							this.openAccordion( $tab_panel );
						}
					};

					/**
					 * Open an accordion. open tab, make it open in a
					 * pretty way on tablet/mobile
					 *
					 * @param $tab_panel -
					 *            jQuery element of the tabpnael being
					 *            opened
					 */

					Tabs.prototype.openAccordion = function( $tab_panel ) {
						this.closeTab();
						this.openTab( $tab_panel );
						this.currentTab.$title.focus();
						jQuery( "html, body" ).animate({
							scrollTop : $tab_panel.offset().top - 110
						}, 500 );
					};

					/**
					 * Open tab and the initial content to display
					 */

					Tabs.prototype.init = function() {
						var $startingTab;
						// save all elements that will become tabs
						this.$tab_panels = this.$container.find( this.options.tab_class_panel );
						this.fetchTabData();
						this.$accordion = this.$container.find( ".accordion-wrapper" ).attr( "role", "tablist" );
						this.bindAccordionEvents();
						// if there's more than 1 tab create the tab
						// navigation
						if ( this.$tab_panels.length > 1 ) {
							this.createTabNav();
							this.bindNavEvents();
						}

						$startingTab = this.$tab_panels.eq( this.options.default_tab );

						if ( this.$tab_panels.filter( ".tabs-container__default" ).length ) {
							$startingTab = this.$tab_panels.filter( ".tabs-container__default" );
						}

						this.openTab( $startingTab );
					};

					return Tabs;
				})();

				jQuery( function() {
					window.Tabs = Tabs;
					new window.Tabs( jQuery( '#TabContainer' ) );
				});
			}).call( this );
		},

		boldgridURLs : function() {
			jQuery( function() {
				var path = window.location.search.substr( 1 ),
				queryBits = path.split( '&' ),
				parameters = {},
				i;

				for ( i = 0; i < queryBits.length; i++ ) {
					( function() {
						var keyval = queryBits[i].split( '=' );
						parameters[decodeURIComponent( keyval[0] )] = decodeURIComponent( keyval[1] );
					}());
				}

				var tabs = parameters.tab;
				var tutorials = parameters.tutorial;

				switch ( tabs ) {
					case 'inspirations':
						jQuery( 'a#TabController-Tab0' ).click();
						if ( tutorials > -1 ) {
							jQuery( '#tutorial0' + parameters.tutorial + '' ).click();
						}
						break;
					case 'customizations':
						jQuery( 'a#TabController-Tab1' ).click();
						if ( tutorials > -1 ) {
							jQuery( '#tutorial1' + parameters.tutorial + '' ).click();
						}
						break;
					case 'advanced':
						jQuery( 'a#TabController-Tab2' ).click();
						if ( tutorials > -1 ) {
							jQuery( '#tutorial2' + parameters.tutorial + '' ).click();
						}
						break;
					default:
						jQuery( 'a#TabController-Tab0' ).click();
						if ( tutorials > -1 ) {
							jQuery( '#tutorial0' + parameters.tutorial + '' ).click();
						}
				}
			});
		},
		// initialize
		initialize : function() {
			this.render();
		},
		// render
		render : function() {
			this.boldgridYouTubePlayer();
			this.boldgridTabData();
			this.boldgridTabs();
			this.boldgridURLs();
		}
	});

	// Router for BoldGrid Dashboard Widget
	var BoldgridRouter = Backbone.Router.extend({
		/**
		 * This isn't really necessary at the moment, but gives future expansion
		 * of this widget ease. Just using # for now, but eventually having the
		 * widget display relevant information based on the customer's journey
		 * within BoldGrid/WP setting up new views with URL hashes will be
		 * simple and maintainable.
		 *
		 * @since 1.13
		 */
		// home route, or empty @boldgriddashRoute
		routes : {
			'' : 'boldgriddashRoute',
		},
		// main route for BoldGridDashView
		boldgriddashRoute : function() {
			// Create new BoldGridDashView to display widget on WP Dashboard
			var boldgriddashView = new BoldGridDashView();
			// @el send data to #boldgrid-welcome-custom
			jQuery( '#boldgrid-welcome-custom' ).html( boldgriddashView.el );
			// since everything is rendered and ready, display the initial set
			// of tabs
			jQuery( ".boldgrid-tab-content-wrapper[data-link-key='0']" ).show();
		}
	});
	// setup
	var boldgridRouter = new BoldgridRouter();
	// and start
	Backbone.history.start();
}( jQuery, _, Backbone ) );
